package tomek.it.graphics;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*		Structure:  
 		JFrame  (BorderLayout)	f
 		 +---->  JPanel (FlowLayout) [BorderLayout.CENTER]		cards
 		 | 		  +---->  JPanel (FlowLayout)		jp1
 		 | 		  +---->  JPanel (FlowLayout)		jp2
 		 | 		  +---->  JPanel (FlowLayout)		jp3
 		 +---->  JPanel (CardLayout) [BorderLayout.SOUTH]		control
 		  		  +---->  JButton		b1
		  		  +---->  JButton		b2
*/

public class CardPanel00d {

    private final static Random random = new Random();
    
    private final static int defaultWidth = 320;
    private final static int defaultHeight = 240;
    
    private static void createAndShowGUI() throws MalformedURLException {
 
    	JFrame f = new JFrame("CardLayout DEMO");
    	
    	final String previous = "<< Prev";
    	final String next = "Next >>";
    	
        JPanel cards = new JPanel(new CardLayout());
        JPanel control = new JPanel();
        
    	ActionListener myActionListener = new ActionListener() {
    		public void actionPerformed(ActionEvent e) {
                CardLayout cl = (CardLayout) cards.getLayout();
                if (e.getActionCommand().equals(previous)) cl.previous(cards);
                else if (e.getActionCommand().equals(next)) cl.next(cards);
    		}
    	};
     
        JButton b1 = new JButton(previous);
        b1.addActionListener(myActionListener);
        
        JButton b2 = new JButton(next);
        b2.addActionListener(myActionListener);

        control.add(b1);
        control.add(b2);
        

		MouseListener myMouseListener = new MouseListener() {

			public void mouseClicked(MouseEvent e) {}

			public synchronized void mousePressed(MouseEvent e) {
				System.out.println(e);
				((JPanel)e.getSource()).setBackground(new Color(random.nextInt()));
			}

			public void mouseReleased(MouseEvent e) {}

			public void mouseEntered(MouseEvent e) {}

			public void mouseExited(MouseEvent e) {}

		};
        
        JPanel jp1 = new JPanel();
        jp1.addMouseListener(myMouseListener);
        jp1.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp1.setBackground(new Color(random.nextInt()));
        jp1.add(new JLabel("First"));
        
        JPanel jp2 = new JPanel();
        jp2.addMouseListener(myMouseListener);
        jp2.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp2.setBackground(new Color(random.nextInt()));
        jp2.add(new JLabel("Second"));
 
        JPanel jp3 = new JPanel();
        jp3.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp3.setBackground(Color.WHITE);
    	{
    	      ImageIcon image = new ImageIcon(new URL("https://www.agh.edu.pl/home/ckim/multimedia/znak_graficzny/znak_bez_nazwy/agh_znk_wbr_rgb_150ppi.jpg"));
    	      System.out.printf("Image size: %2d x %2d. Default: %d x %d.\n", image.getIconHeight(), image.getIconWidth(), defaultHeight, defaultWidth);
    	      float mod = Math.max(image.getIconHeight()/(float)defaultHeight, image.getIconWidth()/(float)defaultWidth);
    	      int newHeight = (int)(0.4999+image.getIconHeight()/mod);
       	      int newWidth = (int)(0.4999+image.getIconWidth()/mod);
       	      System.out.printf("After modification: %2d (%.2f) x %2d (%.2f)\n", newHeight, image.getIconHeight()/mod, newWidth, image.getIconWidth()/mod);
 
    	      ImageIcon image2 = new ImageIcon(image.getImage().getScaledInstance(newWidth, newHeight, Image.SCALE_SMOOTH));
    	      JLabel label = new JLabel(image2);
    	      
    	      jp3.add(label);
    	}

        
        cards.add(jp1);
        cards.add(jp2);
        cards.add(jp3);
        
        f.add(cards, BorderLayout.CENTER);
        f.add(control, BorderLayout.SOUTH);
        
        f.pack();
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
    }
        
    public static void main(String[] args) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() { try {
				createAndShowGUI();
			} catch (MalformedURLException e) {
				e.printStackTrace();
			} }
        });        
    }
    
}
